var FINLog=new Object();

FINLog.GetDateTime = function()
{
	var out = "";
	
	var currentTime = new Date();
	var month = currentTime.getMonth() + 1;
	var day = currentTime.getDate();
	var year = currentTime.getFullYear();
	var hours = currentTime.getHours();
	var minutes = currentTime.getMinutes();
	var seconds = currentTime.getSeconds();
	if (minutes < 10)
		minutes = "0" + minutes;
	if (seconds < 10)
		seconds = "0" + seconds;
		
	out = year + "/" + month + "/" + day + " " + hours + ":" + minutes + ":" + seconds;
	
	return out;
}

FINLog.RecordSession=function()
{
	if(FINLog.currentLog != undefined)
	{
		var currentEpoch = (new Date()).getTime() / 1000;
		
		FINLog.currentLog.finished = FINLog.GetDateTime();
		FINLog.currentLog.finishedEpoch = currentEpoch;
		FINLog.currentLog.result = "Cancelled";
		FINLog.currentLog.supportType = "";
		FINLog.currentLog.duration = FINLog.currentLog.finishedEpoch - FINLog.currentLog.startedEpoch;
		
		FINLog.session.problems.push(FINLog.currentLog);
		FINLog.currentLog = undefined;
		
		FINLog.session.finished = FINLog.GetDateTime();
		FINLog.session.finishedEpoch = currentEpoch;
		FINLog.session.result = "Cancelled";	
	}

	if(CefRunning() && FINLog.session)
	{
		cef.FixItNow.RecordSession(FINLog.session);
	}
	
	FINLog.session = undefined;
}

FINLog.HandleNode=function(node)
{
	if(!node.Log) //This should never happen
		return;
	
	if(node.Log.Function == "StartSession")
	{
		console.log("StartSession - (type:" + node.Log.Type + ")");
		
		FINLog.session = new Object();
		FINLog.session.problems = new Array();	
		
		//started, finished, type, rating
		FINLog.session.started = FINLog.GetDateTime();
		FINLog.session.startedEpoch = (new Date()).getTime() / 1000;
		FINLog.session.type = node.Log.Type;
	}
	else if(node.Log.Function == "FinishSession")
	{
		console.log("FinishSession - (Result:" + node.Log.Result + ")");
		
		FINLog.session.finished = FINLog.GetDateTime();
		FINLog.session.finishedEpoch = (new Date()).getTime() / 1000;
		FINLog.session.result = node.Log.Result;	
	}
	else if(node.Log.Function == "StartProblem")
	{
		if(FINLog.currentLog)
		{
			//SHOULDN'T GET HERE!! Close off and continue?
			var a = 0;
			console.error("FINLog.HandleNode.StartProblem - currentLog already defined!!");
			return;
		}
	
		FINLog.currentLog = new Object();
		FINLog.currentLog.started = FINLog.GetDateTime();
		FINLog.currentLog.startedEpoch = (new Date()).getTime() / 1000;
		FINLog.currentLog.problem = node.Log.Problem;
		FINLog.currentLog.type = FINLog.session.type;
		FINLog.currentLog.resolutions = new Array();
	}	
	else if(node.Log.Function == "FinishProblem")
	{
		if(FINLog.currentLog == undefined)
		{
			//SHOULDN'T GET HERE!! Close off and continue?
			var a = 0;
			console.error("FINLog.HandleNode.FinishProblem - currentLog undefined!!");
			return;
		}
		
		var currentEpoch = (new Date()).getTime() / 1000;
	
		FINLog.currentLog.finished = FINLog.GetDateTime();
		FINLog.currentLog.finishedEpoch = currentEpoch;
		FINLog.currentLog.result = node.Log.Result;
		FINLog.currentLog.supportType = node.Log.SupportType;
		FINLog.currentLog.duration = FINLog.currentLog.finishedEpoch - FINLog.currentLog.startedEpoch;

		FINLog.session.problems.push(FINLog.currentLog);
		FINLog.currentLog = undefined;
		
		if(node.Log.Result == "CompletedFailed") // If problem failed, end the session with failure.
		{
			FINLog.session.finished = FINLog.GetDateTime();
			FINLog.session.finishedEpoch = currentEpoch;
			FINLog.session.result = "Fail";	
		}
	}
	else if(node.Log.Function == "SetResolution")
	{
		if(!FINLog.currentLog)
		{
			console.error("FINLog.HandleNode.SetResolution - no current log!!");
			return;
		}
			
		FINLog.currentLog.resolutions.push(node.Log.Resolution);
	}	
	else if(node.Log.Function == "StartSessionAndProblem")
	{
		console.log("StartSessionAndProblem - (type:" + node.Log.Type + ")");
		
		if(FINLog.currentLog)
		{
			//SHOULDN'T GET HERE!! Close off and continue?
			var a = 0;
			console.error("FINLog.HandleNode.StartSessionAndProblem - currentLog already defined!!");
			return;
		}		
		
		FINLog.session = new Object();
		FINLog.session.problems = new Array();	
		
		//started, finished, type, rating
		FINLog.session.started = FINLog.GetDateTime();
		FINLog.session.startedEpoch = (new Date()).getTime() / 1000;
		FINLog.session.type = node.Log.Type;
	
		FINLog.currentLog = new Object();
		FINLog.currentLog.started = FINLog.GetDateTime();
		FINLog.currentLog.startedEpoch = (new Date()).getTime() / 1000;
		FINLog.currentLog.problem = node.Log.Problem;
		FINLog.currentLog.type = FINLog.session.type;
		FINLog.currentLog.resolutions = new Array();	
	}
	else if(node.Log.Function == "FinishProblemAndSession")
	{		
		var currentEpoch = (new Date()).getTime() / 1000;
	
		if(FINLog.currentLog)
		{
			FINLog.currentLog.finished = FINLog.GetDateTime();
			FINLog.currentLog.finishedEpoch = currentEpoch;
			FINLog.currentLog.result = node.Log.Result;
			FINLog.currentLog.supportType = node.Log.SupportType;
			FINLog.currentLog.duration = FINLog.currentLog.finishedEpoch - FINLog.currentLog.startedEpoch;

			FINLog.session.problems.push(FINLog.currentLog);
			FINLog.currentLog = undefined;
		}
		
		FINLog.session.finished = FINLog.GetDateTime();
		FINLog.session.finishedEpoch = currentEpoch;
		FINLog.session.result = node.Log.Result;		
	}


	
	// node.LogFunction
	// node.LogResult
	// node.LogType
	// node.LogProblem
}